<?php
/**
 * Options page.
 *
 * @package PLAYER\Admin\Pages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter( 'ctpl-options', 'ctpl_options_page' );
/**
 * This function is a ctpl-options filter callback to display WP-Script logo & tabs at the top of the Xbox options page.
 *
 * @param string $options_table - default options HTML string to render the Xbox options in the page.
 * @return $output
 */
function ctpl_options_page( $options_table ) {
	$output  = '<div id="wp-script"><div class="content-tabs">';
	$output .= WPSCORE()->display_logo( false );
	$output .= WPSCORE()->display_tabs( false );
	$output .= '
		<div class="tab-content tab-options">
			<div class="tab-pane fade in active" id="CTPL-options-tab">
				<div v-cloak>
					<ul class="list-inline">
						<li class="active"><a href="admin.php?page=ctpl-options">' . __( 'Options', 'ctpl_lang' ) . '</a></li>
					</ul>
				</div>
			</div>';
	$output .= $options_table;
	$output .= '</div>';
	$output .= WPSCORE()->display_footer( false );
	$output .= '</div></div>';
	return $output;
}

add_action( 'xbox_init', 'ctpl_options' );

/**
 * This function is a xbox_init action callback to define all the plugin Xbox options.
 *
 * @return void
 */
function ctpl_options() {
	$options = array(
		'id'         => 'CTPL-options',
		'icon'       => XBOX_URL . 'img/xbox-light-small.png', // Menu icon.
		'skin'       => 'pink', // Skins: blue, lightblue, green, teal, pink, purple, bluepurple, yellow, orange'.
		'layout'     => 'boxed', // wide.
		'header'     => array(
			'icon' => '<img src="' . XBOX_URL . 'img/xbox-light.png"/>',
			'desc' => 'Customize here your Theme',
		),
		'capability' => 'edit_published_posts',
	);
	$xbox    = xbox_new_admin_page( $options );

	$items['wps-player-general']     = '<i class="xbox-icon xbox-icon-gear"></i>' . __( 'General', 'ctpl_lang' );
	$items['wps-player-advertising'] = '<i class="xbox-icon xbox-icon-money"></i>' . __( 'Advertising', 'ctpl_lang' );
	$items['wps-player-transformer'] = ' <i class="xbox-icon xbox-icon-rocket"></i>' . __( 'Transformer', 'ctpl_lang' );

	$xbox->add_main_tab(
		array(
			'name'  => 'Main tab',
			'id'    => 'main-tab',
			'items' => $items,
		)
	);

	/**
	 * GENERAL
	 */
		$xbox->open_tab_item( 'wps-player-general' );
	if ( ! CTPL()->is_wps_theme() ) :
			$xbox->add_field(
				array(
					'id'      => 'responsive-player',
					'name'    => __( 'Force responsive', 'ctpl_lang' ),
					'type'    => 'radio',
					'default' => 'no',
					'desc'    => __( 'Set yes if your theme does not manage responsive style for player.', 'ctpl_lang' ),
					'items'   => array(
						'yes' => __( 'Yes', 'ctpl_lang' ),
						'no'  => __( 'No', 'ctpl_lang' ),
					),
				)
			);
	endif;
		$xbox->add_field(
			array(
				'id'         => 'main-color',
				'name'       => __( 'Main color', 'ctpl_lang' ),
				'type'       => 'colorpicker',
				'default'    => '#FF3565',
				'desc'       => __( 'Choose the color of the progress bar and close ad button.', 'ctpl_lang' ),
				'attributes' => array(
					'spellcheck' => 'false',
				),
			)
		);
		$xbox->add_field(
			array(
				'id'      => 'ctpl-loading-video-text',
				'name'    => __( 'Loading video text', 'ctpl_lang' ),
				'type'    => 'text',
				'default' => 'Load video',
				'grid'    => '4-of-8',
				'desc'    => __( 'Text when loading the video.', 'ctpl_lang' ),
			)
		);
		$xbox->open_mixed_field(
			array(
				'id'   => 'button-settings',
				'name' => __( 'Button labels', 'ctpl_lang' ),
			)
		);
		$xbox->add_field(
			array(
				'id'      => 'ctpl-button-close-video-label',
				'name'    => __( 'Close and Play label', 'ctpl_lang' ),
				'type'    => 'text',
				'default' => 'Close and play',
				'grid'    => '4-of-8',
				'desc'    => esc_html__( 'Button text to close ads over <video> tags', 'ctpl_lang' ),
			)
		);
		$xbox->add_field(
			array(
				'id'      => 'ctpl-button-close-iframe-label',
				'name'    => __( 'Close label', 'ctpl_lang' ),
				'type'    => 'text',
				'default' => 'Close',
				'grid'    => '4-of-8',
				'desc'    => esc_html__( 'Button text to close ads over <iframe> tags', 'ctpl_lang' ),
			)
		);
		$xbox->close_mixed_field();
		$xbox->add_field(
			array(
				'id'      => 'vp-autoplay',
				'name'    => __( 'Autoplay', 'ctpl_lang' ),
				'type'    => 'switcher',
				'default' => 'off',
				'grid'    => '2-of-8',
				'desc'    => __( 'The video plays automatically.', 'ctpl_lang' ),
			)
		);
		$xbox->add_field(
			array(
				'id'      => 'vp-download',
				'name'    => __( 'Allow download mp4 videos', 'ctpl_lang' ),
				'type'    => 'switcher',
				'default' => 'off',
				'grid'    => '2-of-8',
				'desc'    => __( 'Display a button in the video player to download the video. Works only with mp4 files (Not with m3u8 files. Not with iframes.)', 'ctpl_lang' ),
			)
		);
		$xbox->add_field(
			array(
				'id'      => 'logo-watermark-video-player',
				'name'    => __( 'Logo', 'ctpl_lang' ),
				'type'    => 'switcher',
				'default' => 'off',
				'grid'    => '2-of-8',
				'desc'    => __( 'Display your logo inside the video player.', 'ctpl_lang' ),
			)
		);

		$xbox->open_mixed_field(
			array(
				'id'   => 'displayed-when:switch:logo-watermark-video-player:on:logo-watermark-settings',
				'name' => __( 'Logo settings', 'ctpl_lang' ),
			)
		);
			$xbox->add_field(
				array(
					'id'         => 'image-logo-watermark-file',
					'name'       => __( 'Image logo URL', 'ctpl_lang' ),
					'type'       => 'file',
					'grid'       => '8-of-8',
					'desc'       => __( 'If empty, your main logo image will be used by default.', 'ctpl_lang' ),
					'options'    => array(
						'preview_size' => array(
							'width'  => '100%',
							'height' => 'auto',
						),
					),
					'attributes' => array(
						'spellcheck' => 'false',
					),
				)
			);
			$xbox->add_field(
				array(
					'id'      => 'logo-position-video-player',
					'name'    => _x( 'Position', 'Logo position', 'ctpl_lang' ),
					'type'    => 'select',
					'default' => 'top-right',
					'items'   => array(
						'top-left'     => 'Top left',
						'top-right'    => 'Top right',
						'bottom-left'  => 'Bottom left',
						'bottom-right' => 'Bottom right',
					),
					'grid'    => '2-of-8',
					'desc'    => __( 'Set the position of your logo inside the video player.', 'ctpl_lang' ),
				)
			);
			$xbox->add_field(
				array(
					'id'         => 'logo-watermark-width',
					'name'       => _x( 'Width', 'Logo width', 'ctpl_lang' ),
					'type'       => 'number',
					'default'    => 25,
					'attributes' => array(
						'min'       => 1,
						'max'       => 100,
						'step'      => 1,
						'precision' => 0,
					),
					'options'    => array(
						'unit' => '%',
					),
					'desc'       => __( 'Set the logo width (1% - 100%).', 'ctpl_lang' ),
					'grid'       => '2-of-8',
				)
			);
			$xbox->add_field(
				array(
					'id'         => 'logo-watermark-opacity',
					'name'       => _x( 'Opacity', 'Logo opacity', 'ctpl_lang' ),
					'type'       => 'number',
					'default'    => 50,
					'attributes' => array(
						'min'       => 1,
						'max'       => 100,
						'step'      => 1,
						'precision' => 0,
					),
					'options'    => array(
						'unit' => '%',
					),
					'desc'       => __( 'Set the logo opacity (1% - 100%).', 'ctpl_lang' ),
					'grid'       => '2-of-8',
				)
			);
			$xbox->add_field(
				array(
					'id'      => 'logo-watermark-grayscale',
					'name'    => _x( 'Grayscale', 'Logo grayscale', 'ctpl_lang' ),
					'type'    => 'switcher',
					'default' => 'on',
					'grid'    => '2-of-8 last',
				)
			);
		$xbox->close_mixed_field();
	$xbox->close_tab_item( 'wps-player-general' );

	/**
	 * ADVERTISING
	 */
	$xbox->open_tab_item( 'wps-player-advertising' );
		$xbox->add_field(
			array(
				'id'         => 'inside-player-ad-zone-1-desktop',
				'name'       => __( 'Before play ad zone 1', 'ctpl_lang' ) . "\n" . '(' . __( 'works on iframe and mp4', 'ctpl_lang' ) . ')',
				'type'       => 'textarea',
				'grid'       => '2-of-6',
				'desc'       => '<img src="' . CTPL_URL . 'admin/assets/img/theme-options/inside-player-happy-zone-1-desktop.jpg">',
				'attributes' => array(
					'rows'       => 6,
					'spellcheck' => 'false',
				),
			)
		);
		$xbox->add_field(
			array(
				'id'         => 'inside-player-ad-zone-2-desktop',
				'name'       => __( 'Before play ad zone 2', 'ctpl_lang' ) . "\n" . '(' . __( 'works on iframe and mp4', 'ctpl_lang' ) . ')',
				'type'       => 'textarea',
				'grid'       => '2-of-6',
				'desc'       => '<img src="' . CTPL_URL . 'admin/assets/img/theme-options/inside-player-happy-zone-2-desktop.jpg">',
				'attributes' => array(
					'rows'       => 6,
					'spellcheck' => 'false',
				),
			)
		);
		$xbox->add_field(
			array(
				'id'         => 'vp-ad-pause-1',
				'name'       => __( 'On pause ad zone 1', 'ctpl_lang' ) . "\n" . '(' . __( 'works on mp4 only', 'ctpl_lang' ) . ')',
				'type'       => 'textarea',
				'grid'       => '2-of-6',
				'desc'       => '<img src="' . CTPL_URL . 'admin/assets/img/theme-options/inside-player-happy-zone-1-desktop.jpg">',
				'attributes' => array(
					'rows'       => 6,
					'spellcheck' => 'false',
				),
			)
		);
		$xbox->add_field(
			array(
				'id'         => 'vp-ad-pause-2',
				'name'       => __( 'On pause ad zone 2', 'ctpl_lang' ) . "\n" . '(' . __( 'works on mp4 only', 'ctpl_lang' ) . ')',
				'type'       => 'textarea',
				'grid'       => '2-of-6',
				'desc'       => '<img src="' . CTPL_URL . 'admin/assets/img/theme-options/inside-player-happy-zone-2-desktop.jpg">',
				'attributes' => array(
					'rows'       => 6,
					'spellcheck' => 'false',
				),
			)
		);
		$xbox->open_mixed_field(
			array(
				'id'   => 'pre-roll-settings',
				'name' => __( 'Pre-roll in-stream ad', 'ctpl_lang' ) . "\n" . '(' . __( 'works on mp4 only', 'ctpl_lang' ) . ')',
			)
		);
			$xbox->add_field(
				array(
					'id'         => 'vp-pre-roll-url',
					'name'       => __( 'URL', 'ctpl_lang' ),
					'type'       => 'text',
					'grid'       => '3-of-6',
					'default'    => '',
					'desc'       => __( 'Display an in-stream video advertising at the beginning of the video.', 'ctpl_lang' ),
					'attributes' => array(
						'spellcheck' => 'false',
					),
				)
			);
		$xbox->close_mixed_field();
		$xbox->open_mixed_field(
			array(
				'id'   => 'mid-roll-settings',
				'name' => __( 'Mid-roll in-stream ad', 'ctpl_lang' ) . "\n" . '(' . __( 'works on mp4 only', 'ctpl_lang' ) . ')',
			)
		);
		$xbox->add_field(
			array(
				'id'         => 'vp-mid-roll-url',
				'name'       => __( 'URL', 'ctpl_lang' ),
				'type'       => 'text',
				'grid'       => '3-of-6',
				'default'    => '',
				'desc'       => __( 'Display an in-stream video advertising at the middle of the video.', 'ctpl_lang' ),
				'attributes' => array(
					'spellcheck' => 'false',
				),
			)
		);
		$xbox->add_field(
			array(
				'id'         => 'vp-mid-roll-timer',
				'name'       => _x( 'Timer', 'Mid-roll in-stream timer', 'ctpl_lang' ),
				'type'       => 'number',
				'default'    => 50,
				'attributes' => array(
					'min'       => 1,
					'max'       => 99,
					'step'      => 1,
					'precision' => 0,
				),
				'options'    => array(
					'unit' => '%',
				),
				'desc'       => __( 'Choose when in the video you want to display the mid-roll ad (1% - 99%).', 'ctpl_lang' ),
				'grid'       => '2-of-8 last',
			)
		);
	$xbox->close_mixed_field();
	$xbox->close_tab_item( 'wps-player-advertising' );

	/**
	 * TRANSFORMER
	 */
	$xbox->open_tab_item( 'wps-player-transformer' );
		$xbox->open_mixed_field( array( 'name' => __( 'HTML tags to transform', 'ctpl_lang' ) ) );
		$xbox->add_field(
			array(
				'id'      => 'transform-basic-video-player',
				'name'    => esc_html__( '<video> tags', 'ctpl_lang' ),
				'type'    => 'switcher',
				'grid'    => '3-of-6',
				'default' => 'on',
				'desc'    => esc_html__( 'WPS Player will play <video> tags and video shortcodes', 'ctpl_lang' ),
			)
		);
		$xbox->add_field(
			array(
				'id'      => 'transform-iframe-video-player',
				'name'    => esc_html__( '<iframe> tags', 'ctpl_lang' ),
				'type'    => 'switcher',
				'grid'    => '3-of-6 last',
				'default' => 'on',
				'desc'    => esc_html__( 'WPS Player will play <iframe> tags', 'ctpl_lang' ),
			)
		);
	$xbox->close_mixed_field();
		$xbox->open_mixed_field( array( 'name' => __( 'Exclude transform', 'ctpl_lang' ) ) );
		$xbox->add_field(
			array(
				'id'         => 'bypass-transform',
				'name'       => __( 'List of classes and ids to exclude (one per line)', 'ctpl_lang' ),
				'type'       => 'textarea',
				'default'    => '.exclude-transform',
				'grid'       => '6-of-8 last',
				'desc'       => esc_html__( 'Enter class names (ie. .exclude-class) or ids (ie. #exclude-id) of elements you do not want to be transformed. Applied on <iframe> and <video> tags.', 'ctpl_lang' ),
				'attributes' => array(
					'rows'       => 6,
					'spellcheck' => 'false',
				),
			)
		);
		$xbox->close_mixed_field();

		$xbox->open_mixed_field( array( 'name' => __( 'Transform adult tubes (experimental)', 'ctpl_lang' ) ) );
			$xbox->add_field(
				array(
					'name'    => 'Redtube',
					'id'      => 'transform-redtube-player',
					'type'    => 'switcher',
					'grid'    => '3-of-6',
					'default' => 'on',
					'desc'    => __( 'WPS Player will try to transform Redtube iframes.', 'ctpl_lang' ),
				)
			);
			$xbox->add_field(
				array(
					'name'    => 'Xvideos',
					'id'      => 'transform-xvideos-player',
					'type'    => 'switcher',
					'grid'    => '3-of-6 last',
					'default' => 'on',
					'desc'    => __( 'WPS Player will try to transform Xvideos iframes.', 'ctpl_lang' ),
				)
			);
			$xbox->add_field(
				array(
					'name'    => 'Youporn',
					'id'      => 'transform-youporn-player',
					'type'    => 'switcher',
					'grid'    => '3-of-6',
					'default' => 'on',
					'desc'    => __( 'WPS Player will try to transform Youporn iframes.', 'ctpl_lang' ),
				)
			);
			$xbox->add_field(
				array(
					'name'    => 'Youporn Gay',
					'id'      => 'transform-youporngay-player',
					'type'    => 'switcher',
					'grid'    => '3-of-6 last',
					'default' => 'on',
					'desc'    => __( 'WPS Player will try to transform Youporn Gay videos.', 'ctpl_lang' ),
				)
			);
		$xbox->close_mixed_field();

		$xbox->open_mixed_field(
			array(
				'name' => __( 'Proxy', 'ctpl_lang' ),
				'desc' => __( 'Use a <a href="https://docs.wp-script.com/plugins/wps-player/options/transformer/#proxy-experimental" target="_blank">Rotating Proxy</a> if the transformation does not work anymore.', 'ctpl_lang' ),
			)
		);
			$xbox->add_field(
				array(
					'id'         => 'ctpl-proxy-ip',
					'name'       => __( 'IP Address', 'ctpl_lang' ),
					'type'       => 'text',
					'grid'       => '2-of-8',
					'desc'       => __( 'Enter a valid Proxy IP.', 'ctpl_lang' ),
					'attributes' => array(
						'spellcheck' => 'false',
					),
				)
			);
			$xbox->add_field(
				array(
					'id'         => 'ctpl-proxy-port',
					'name'       => _x( 'Port', 'Proxy port', 'ctpl_lang' ),
					'type'       => 'text',
					'desc'       => __( 'Enter a valid Proxy Port.', 'ctpl_lang' ),
					'grid'       => '2-of-8',
					'attributes' => array(
						'spellcheck' => 'false',
					),
				)
			);
			$xbox->add_field(
				array(
					'id'         => 'ctpl-proxy-user',
					'name'       => _x( 'User', 'Proxy user', 'ctpl_lang' ),
					'type'       => 'text',
					'grid'       => '2-of-8',
					'desc'       => __( 'Enter the user name if auth required.', 'ctpl_lang' ),
					'attributes' => array(
						'spellcheck' => 'false',
					),
				)
			);
			$xbox->add_field(
				array(
					'id'         => 'ctpl-proxy-password',
					'name'       => _x( 'Password', 'Proxy password', 'ctpl_lang' ),
					'type'       => 'text',
					'desc'       => __( 'Enter the password if auth required.', 'ctpl_lang' ),
					'grid'       => '2-of-8',
					'attributes' => array(
						'spellcheck' => 'false',
					),
				)
			);
		$xbox->close_mixed_field();
	$xbox->close_tab_item( 'wps-player-transformer' );

	$xbox->close_tab( 'main-tab' );
}
