<?php
/**
 * KOT Theme Customizer
 *
 * @package wpst
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
if ( ! function_exists( 'wpst_customize_register' ) ) {
	/**
	 * Register basic customizer support.
	 *
	 * @param object $wp_customize Customizer reference.
	 */
	function wpst_customize_register( $wp_customize ) {
		// $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
		// $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
		// $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

		$wp_customize->remove_section( 'tagline' );
		$wp_customize->remove_section( 'colors' );
		$wp_customize->remove_section( 'static_front_page' );
		$wp_customize->remove_section( 'background_image' );
		// $wp_customize->remove_panel( 'widgets' );
	}
}
add_action( 'customize_register', 'wpst_customize_register' );

if ( ! function_exists( 'wpst_theme_customize_register' ) ) {
	/**
	 * Register individual settings through customizer's API.
	 *
	 * @param WP_Customize_Manager $wp_customize Customizer reference.
	 */
	function wpst_theme_customize_register( $wp_customize ) {
		/*********************************/
		/****** NEW SECTION GENERAL */
		/*********************************/
		$wp_customize->add_section(
			'wpst_general',
			array(
				'title'    => __( 'General', 'wpst' ),
				'priority' => 10,
			)
		);

		$wp_customize->add_setting(
			'enable_video_preview',
			array(
				'default'   => 'yes',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_enable_video_preview',
				array(
					'label'             => __( 'Enable video preview', 'wpst' ),
					'description'       => __( 'Enable video preview on thumb mouse hover.', 'wpst' ),
					'section'           => 'wpst_general',
					'settings'          => 'enable_video_preview',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'yes' => __( 'Yes', 'wpst' ),
						'no'  => __( 'No', 'wpst' ),
					),
					// 'priority'          => '10',
				)
			)
		);

		$wp_customize->add_setting(
			'enable_thumbs_rotation',
			array(
				'default'   => 'yes',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_enable_thumbs_rotation',
				array(
					'label'             => __( 'Enable thumbs rotation', 'wpst' ),
					'description'       => __( 'Enable thumbs rotation on thumb mouse hover.', 'wpst' ),
					'section'           => 'wpst_general',
					'settings'          => 'enable_thumbs_rotation',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'yes' => __( 'Yes', 'wpst' ),
						'no'  => __( 'No', 'wpst' ),
					),
					// 'priority'          => '10',
				)
			)
		);

		$wp_customize->add_setting(
			'enable_video_tracking_link',
			array(
				'default'   => 'no',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_enable_video_tracking_link',
				array(
					'label'             => __( 'Enable video tracking link', 'wpst' ),
					'description'       => __( 'Display a banner with the video tracking link.', 'wpst' ),
					'section'           => 'wpst_general',
					'settings'          => 'enable_video_tracking_link',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'yes' => __( 'Yes', 'wpst' ),
						'no'  => __( 'No', 'wpst' ),
					),
					// 'priority'          => '10',
				)
			)
		);

		/********************************/
		/****** NEW SECTION COLORS */
		/********************************/
		$wp_customize->add_section(
			'wpst_colors',
			array(
				'title'    => __( 'Colors', 'wpst' ),
				'priority' => 20,
			)
		);

		// Background color
		$wp_customize->add_setting(
			'main_color', // give it an ID
			array(
				'default'   => '#3f1d78', // Give it a default
				'transport' => 'refresh',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'wpst_main_color',
				array(
					'label'    => __( 'Main Color', 'wpst' ),
					'section'  => 'wpst_colors',
					'settings' => 'main_color',
				)
			)
		);

		// Link color
		$wp_customize->add_setting(
			'link_color', // give it an ID
			array(
				'default'   => '#ed28b5', // Give it a default
				'transport' => 'refresh',
			)
		);
		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'wpst_link_color',
				array(
					'label'    => __( 'Link Color', 'wpst' ), // set the label to appear in the Customizer
					'section'  => 'wpst_colors', // select the section for it to appear under
					'settings' => 'link_color', // pick the setting it applies to
				)
			)
		);

		/*********************************/
		/****** NEW SECTION SIDEBAR */
		/*********************************/
		$wp_customize->add_section(
			'wpst_theme_layout_options',
			array(
				'title'      => __( 'Sidebar', 'wpst' ),
				'capability' => 'edit_theme_options',
				// 'description' => __( 'Container width and sidebar defaults', 'wpst' ),
				'priority'   => 30,
			)
		);

		$wp_customize->add_setting(
			'sidebar_position',
			array(
				'default'   => 'left',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_sidebar_position',
				array(
					'label'             => __( 'Sidebar Positioning', 'wpst' ),
					'description'       => __(
						'Set sidebar\'s default position. Can either be: right, left or none.',
						'wpst'
					),
					'section'           => 'wpst_theme_layout_options',
					'settings'          => 'sidebar_position',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'left'  => __( 'Left sidebar', 'wpst' ),
						'right' => __( 'Right sidebar', 'wpst' ),
						'none'  => __( 'No sidebar', 'wpst' ),
					),
					'priority'          => '30',
				)
			)
		);

		/*************************************/
		/****** NEW SECTION ADVERTISING */
		/*************************************/
		$wp_customize->add_panel(
			'wpst_ads',
			array(
				'capability'     => 'edit_theme_options',
				'priority'       => 50,
				'theme_supports' => '',
				'title'          => __( 'Advertising', 'wpst' ),
				'description'    => __( 'Settings to add ads into your site', 'wpst' ),
			)
		);

		/**
		 * HOME ADS
		 */
		$wp_customize->add_section(
			'wpst_ads_home',
			array(
				'priority'       => 50,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Homepage', 'wpst' ),
				'description'    => __( 'Add your own ads on the homepage.', 'wpst' ),
				'panel'          => 'wpst_ads',
			)
		);

		// Home Ad before videos list
		$wp_customize->add_setting(
			'ads_home_before_list',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_home_before_list',
				array(
					'label'    => esc_html__( 'Ad zone before videos list', 'wpst' ),
					'section'  => 'wpst_ads_home',
					'settings' => 'ads_home_before_list',
					'type'     => 'textarea',
				)
			)
		);

		// Home Ad inside videos list
		$wp_customize->add_setting(
			'ads_home_inside_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-6.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_home_inside_list',
				array(
					'label'    => esc_html__( 'Ad zone inside videos list', 'wpst' ),
					'section'  => 'wpst_ads_home',
					'settings' => 'ads_home_inside_list',
					'type'     => 'textarea',
				)
			)
		);

		// Home Ad after videos list
		$wp_customize->add_setting(
			'ads_home_after_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_home_after_list',
				array(
					'label'    => esc_html__( 'Ad zone after videos list', 'wpst' ),
					'section'  => 'wpst_ads_home',
					'settings' => 'ads_home_after_list',
					'type'     => 'textarea',
				)
			)
		);

		/**
		 * SINGLE VIDEO PAGE ADS
		 */
		$wp_customize->add_section(
			'wpst_ads_single_video_page',
			array(
				'priority'       => 50,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Single Video Page', 'wpst' ),
				'description'    => __( 'Add your own ads on single video pages.', 'wpst' ),
				'panel'          => 'wpst_ads',
			)
		);

		// Single video page Ad in player 1
		$wp_customize->add_setting(
			'ads_single_video_page_in_player_1',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-2.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_single_video_page_in_player_1',
				array(
					'label'    => esc_html__( 'In player ad zone 1', 'wpst' ),
					'section'  => 'wpst_ads_single_video_page',
					'settings' => 'ads_single_video_page_in_player_1',
					'type'     => 'textarea',
				)
			)
		);

		// Single video page Ad in player 2
		$wp_customize->add_setting(
			'ads_single_video_page_in_player_2',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-2.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_single_video_page_in_player_2',
				array(
					'label'    => esc_html__( 'In player ad zone 2', 'wpst' ),
					'section'  => 'wpst_ads_single_video_page',
					'settings' => 'ads_single_video_page_in_player_2',
					'type'     => 'textarea',
				)
			)
		);

		// Single video page Ad under player
		$wp_customize->add_setting(
			'ads_single_video_page_under_player',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_single_video_page_under_player',
				array(
					'label'    => esc_html__( 'Under player ad zone', 'wpst' ),
					'section'  => 'wpst_ads_single_video_page',
					'settings' => 'ads_single_video_page_under_player',
					'type'     => 'textarea',
				)
			)
		);

		// Single video page Ad beside player 1
		$wp_customize->add_setting(
			'ads_single_video_page_beside_player_1',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-2.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_single_video_page_beside_player_1',
				array(
					'label'    => esc_html__( 'Beside player ad zone 1', 'wpst' ),
					'section'  => 'wpst_ads_single_video_page',
					'settings' => 'ads_single_video_page_beside_player_1',
					'type'     => 'textarea',
				)
			)
		);

		// Single video page Ad beside player 2
		$wp_customize->add_setting(
			'ads_single_video_page_beside_player_2',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-2.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_single_video_page_beside_player_2',
				array(
					'label'    => esc_html__( 'Beside player ad zone 2', 'wpst' ),
					'section'  => 'wpst_ads_single_video_page',
					'settings' => 'ads_single_video_page_beside_player_2',
					'type'     => 'textarea',
				)
			)
		);

		// Single video page Ad before related videos
		$wp_customize->add_setting(
			'ads_single_video_page_before_related_videos',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_single_video_page_before_related_videos',
				array(
					'label'    => esc_html__( 'Before related videos ad zone', 'wpst' ),
					'section'  => 'wpst_ads_single_video_page',
					'settings' => 'ads_single_video_page_before_related_videos',
					'type'     => 'textarea',
				)
			)
		);

		// Home Ad inside videos list
		$wp_customize->add_setting(
			'ads_home_inside_related_videos_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-2.png"></a>',
				'transport' => 'refresh',
			)
		);

		/**
		 * ACTORS PAGE ADS
		 */
		$wp_customize->add_section(
			'wpst_ads_actor_page',
			array(
				'priority'       => 50,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Actor Page', 'wpst' ),
				'description'    => __( 'Add your own ads on the Actor pages.', 'wpst' ),
				'panel'          => 'wpst_ads',
			)
		);

		// Actor page Ad before videos list
		$wp_customize->add_setting(
			'ads_actor_page_before_list',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_actor_page_before_list',
				array(
					'label'    => esc_html__( 'Ad zone before videos list', 'wpst' ),
					'section'  => 'wpst_ads_actor_page',
					'settings' => 'ads_actor_page_before_list',
					'type'     => 'textarea',
				)
			)
		);

		// Actor page Ad inside videos list
		$wp_customize->add_setting(
			'ads_actor_page_inside_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-6.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_actor_page_inside_list',
				array(
					'label'    => esc_html__( 'Ad zone inside videos list', 'wpst' ),
					'section'  => 'wpst_ads_actor_page',
					'settings' => 'ads_actor_page_inside_list',
					'type'     => 'textarea',
				)
			)
		);

		// Actor page Ad after videos list
		$wp_customize->add_setting(
			'ads_actor_page_after_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_actor_page_after_list',
				array(
					'label'    => esc_html__( 'Ad zone after videos list', 'wpst' ),
					'section'  => 'wpst_ads_actor_page',
					'settings' => 'ads_actor_page_after_list',
					'type'     => 'textarea',
				)
			)
		);

		/**
		 * CATEGORY PAGE ADS
		 */
		$wp_customize->add_section(
			'wpst_ads_category_page',
			array(
				'priority'       => 50,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Category Page', 'wpst' ),
				'description'    => __( 'Add your own ads on the Category pages.', 'wpst' ),
				'panel'          => 'wpst_ads',
			)
		);

		// Category page Ad before videos list
		$wp_customize->add_setting(
			'ads_category_page_before_list',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_category_page_before_list',
				array(
					'label'    => esc_html__( 'Ad zone before videos list', 'wpst' ),
					'section'  => 'wpst_ads_category_page',
					'settings' => 'ads_category_page_before_list',
					'type'     => 'textarea',
				)
			)
		);

		// Category page Ad inside videos list
		$wp_customize->add_setting(
			'ads_category_page_inside_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-6.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_category_page_inside_list',
				array(
					'label'    => esc_html__( 'Ad zone inside videos list', 'wpst' ),
					'section'  => 'wpst_ads_category_page',
					'settings' => 'ads_category_page_inside_list',
					'type'     => 'textarea',
				)
			)
		);

		// Category page Ad after videos list
		$wp_customize->add_setting(
			'ads_category_page_after_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_category_page_after_list',
				array(
					'label'    => esc_html__( 'Ad zone after videos list', 'wpst' ),
					'section'  => 'wpst_ads_category_page',
					'settings' => 'ads_category_page_after_list',
					'type'     => 'textarea',
				)
			)
		);

		/**
		 * TAG PAGE ADS
		 */
		$wp_customize->add_section(
			'wpst_ads_tag_page',
			array(
				'priority'       => 50,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Tag Page', 'wpst' ),
				'description'    => __( 'Add your own ads on the Tag pages.', 'wpst' ),
				'panel'          => 'wpst_ads',
			)
		);

		// Tag page Ad before videos list
		$wp_customize->add_setting(
			'ads_tag_page_before_list',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_tag_page_before_list',
				array(
					'label'    => esc_html__( 'Ad zone before videos list', 'wpst' ),
					'section'  => 'wpst_ads_tag_page',
					'settings' => 'ads_tag_page_before_list',
					'type'     => 'textarea',
				)
			)
		);

		// Tag page Ad inside videos list
		$wp_customize->add_setting(
			'ads_tag_page_inside_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-6.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_tag_page_inside_list',
				array(
					'label'    => esc_html__( 'Ad zone inside videos list', 'wpst' ),
					'section'  => 'wpst_ads_tag_page',
					'settings' => 'ads_tag_page_inside_list',
					'type'     => 'textarea',
				)
			)
		);

		// Tag page Ad after videos list
		$wp_customize->add_setting(
			'ads_tag_page_after_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_tag_page_after_list',
				array(
					'label'    => esc_html__( 'Ad zone after videos list', 'wpst' ),
					'section'  => 'wpst_ads_tag_page',
					'settings' => 'ads_tag_page_after_list',
					'type'     => 'textarea',
				)
			)
		);

		/**
		 * SEARCH RESULT PAGE ADS
		 */
		$wp_customize->add_section(
			'wpst_ads_search_result_page',
			array(
				'priority'       => 50,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Search Result Page', 'wpst' ),
				'description'    => __( 'Add your own ads on the search result pages.', 'wpst' ),
				'panel'          => 'wpst_ads',
			)
		);

		// Search result page Ad before videos list
		$wp_customize->add_setting(
			'ads_search_result_page_before_list',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_search_result_page_before_list',
				array(
					'label'    => esc_html__( 'Ad zone before videos list', 'wpst' ),
					'section'  => 'wpst_ads_search_result_page',
					'settings' => 'ads_search_result_page_before_list',
					'type'     => 'textarea',
				)
			)
		);

		// Search result page Ad inside videos list
		$wp_customize->add_setting(
			'ads_search_result_page_inside_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-6.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_search_result_page_inside_list',
				array(
					'label'    => esc_html__( 'Ad zone inside videos list', 'wpst' ),
					'section'  => 'wpst_ads_search_result_page',
					'settings' => 'ads_search_result_page_inside_list',
					'type'     => 'textarea',
				)
			)
		);

		// Search result page Ad after videos list
		$wp_customize->add_setting(
			'ads_search_result_page_after_list',
			array(
				'default'   => '<a href="#!"><img src="' . get_template_directory_uri() . '/img/happy-3.png"></a>',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_ads_search_result_page_after_list',
				array(
					'label'    => esc_html__( 'Ad zone after videos list', 'wpst' ),
					'section'  => 'wpst_ads_search_result_page',
					'settings' => 'ads_search_result_page_after_list',
					'type'     => 'textarea',
				)
			)
		);

		/*****************************/
		/****** NEW SECTION SEO */
		/*****************************/
		$wp_customize->add_panel(
			'wpst_seo',
			array(
				'priority'       => 60,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'SEO', 'wpst' ),
				'description'    => __( 'Several settings pertaining my theme', 'wpst' ),
			)
		);

		/**
		 * HOME
		 */
		$wp_customize->add_section(
			'wpst_seo_home',
			array(
				'priority'       => 60,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Homepage', 'wpst' ),
				'description'    => __( 'Rewrite content on homepage to improve SEO.', 'wpst' ),
				'panel'          => 'wpst_seo',
			)
		);

		// Home Hero Position
		$wp_customize->add_setting(
			'seo_home_position',
			array(
				'default'   => 'bottom',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_home_position',
				array(
					'label'             => esc_html__( 'Position', 'wpst' ),
					'description'       => esc_html__( 'Set the position of the title and description of this page. Can either be: top or bottom.', 'wpst' ),
					'section'           => 'wpst_seo_home',
					'settings'          => 'seo_home_position',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'top'    => esc_html__( 'Top', 'wpst' ),
						'bottom' => esc_html__( 'Bottom', 'wpst' ),
					),
					// 'priority'          => '20',
				)
			)
		);

		// HOME SEO Title
		$wp_customize->add_setting(
			'seo_home_title',
			array(
				'default'   => get_bloginfo( 'description' ),
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_home_title',
				array(
					'label'    => __( 'Home Title', 'wpst' ),
					'section'  => 'wpst_seo_home',
					'settings' => 'seo_home_title',
					'type'     => 'text',
				)
			)
		);
		// HOME SEO Description
		$wp_customize->add_setting(
			'seo_home_description',
			array(
				'default'   => 'The best porn videos are on ' . get_bloginfo( 'name' ) . '!',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			// new WP_Customize_Control(
			new Text_Editor_Custom_Control(
				$wp_customize,
				'wpst_seo_home_description',
				array(
					'label'    => __( 'Home Description', 'wpst' ),
					'section'  => 'wpst_seo_home',
					'settings' => 'seo_home_description',
					'type'     => 'textarea',
				)
			)
		);

		/**
		 * SINGLE VIDEO PAGE
		 */
		$wp_customize->add_section(
			'wpst_seo_video',
			array(
				'priority'       => 60,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Single video pages', 'wpst' ),
				'description'    => __( 'Rewrite content on video pages to improve SEO.', 'wpst' ) . wpst_add_variables(
					array(
						'%%video_title%%' => __( 'display video title.', 'wpst' ),
					)
				),
				'panel'          => 'wpst_seo',
			)
		);

		// Video SEO Title
		$wp_customize->add_setting(
			'seo_video_title',
			array(
				'default'   => '%%video_title%%',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_video_title',
				array(
					'label'    => __( 'Video Title', 'wpst' ),
					'section'  => 'wpst_seo_video',
					'settings' => 'seo_video_title',
					'type'     => 'text',
				)
			)
		);
		// Video SEO tracking button
		$wp_customize->add_setting(
			'seo_video_tracking_button',
			array(
				'default'   => 'Download full video now',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_video_tracking_button',
				array(
					'label'    => __( 'Video Tracking Button', 'wpst' ),
					'section'  => 'wpst_seo_video',
					'settings' => 'seo_video_tracking_button',
					'type'     => 'text',
				)
			)
		);

		// Video SEO related videos title.
		$wp_customize->add_setting(
			'seo_related_videos_title',
			array(
				'default'   => 'You like this video? You will also like...',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_related_videos_title',
				array(
					'label'    => __( 'Related Videos Title', 'wpst' ),
					'section'  => 'wpst_seo_video',
					'settings' => 'seo_related_videos_title',
					'type'     => 'text',
				)
			)
		);

		// Video SEO related videos button label.
		$wp_customize->add_setting(
			'seo_more_related_videos_button',
			array(
				'default'   => 'Show more related videos',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_more_related_videos_button',
				array(
					'label'    => __( 'More related videos button label', 'wpst' ),
					'section'  => 'wpst_seo_video',
					'settings' => 'seo_more_related_videos_button',
					'type'     => 'text',
				)
			)
		);
		/**
		 * CAT
		 */
		$wp_customize->add_section(
			'wpst_seo_video_cat',
			array(
				'priority'       => 60,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Category pages', 'wpst' ),
				'description'    => __( 'Rewrite content on category pages to improve SEO.', 'wpst' ) . wpst_add_variables(
					array(
						'%%cat%%' => __( 'display category name.', 'wpst' ),
					)
				),
				'panel'          => 'wpst_seo',
			)
		);

		// Cat Hero Position
		$wp_customize->add_setting(
			'seo_video_cat_position',
			array(
				'default'   => 'top',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_video_cat_position',
				array(
					'label'             => esc_html__( 'Position', 'wpst' ),
					'description'       => esc_html__( 'Set the position of the title and description of this page. Can either be: top or bottom.', 'wpst' ),
					'section'           => 'wpst_seo_video_cat',
					'settings'          => 'seo_video_cat_position',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'top'    => esc_html__( 'Top', 'wpst' ),
						'bottom' => esc_html__( 'Bottom', 'wpst' ),
					),
					// 'priority'          => '20',
				)
			)
		);

		// Cat SEO Slug
		// $wp_customize->add_setting(
		// 'seo_video_cat_slug',
		// array(
		// 'default'   => 'category',
		// 'transport' => 'refresh',
		// )
		// );

		// $wp_customize->add_control(
		// new WP_Customize_Control(
		// $wp_customize,
		// 'wpst_seo_video_cat_slug',
		// array(
		// 'label'    => __( 'Category Slug', 'wpst' ),
		// 'section'  => 'wpst_seo_video_cat',
		// 'settings' => 'seo_video_cat_slug',
		// 'type'     => 'text',
		// )
		// )
		// );

		// Cat SEO Title
		$wp_customize->add_setting(
			'seo_video_cat_title',
			array(
				'default'   => '%%cat%% porn videos',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_video_cat_title',
				array(
					'label'    => __( 'Category Title', 'wpst' ),
					'section'  => 'wpst_seo_video_cat',
					'settings' => 'seo_video_cat_title',
					'type'     => 'text',
				)
			)
		);
		// Cat SEO Description
		$wp_customize->add_setting(
			'seo_video_cat_description',
			array(
				'default'   => 'The best adult %%cat%% videos',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new Text_Editor_Custom_Control(
				$wp_customize,
				'wpst_seo_video_cat_description',
				array(
					'label'    => __( 'Category Description', 'wpst' ),
					'section'  => 'wpst_seo_video_cat',
					'settings' => 'seo_video_cat_description',
					'type'     => 'textarea',
				)
			)
		);

		/**
		 * TAG
		 */
		$wp_customize->add_section(
			'wpst_seo_video_tag',
			array(
				'priority'       => 60,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Tag pages', 'wpst' ),
				'description'    => __( 'Rewrite content on tag pages to improve SEO.', 'wpst' ) . wpst_add_variables(
					array(
						'%%tag%%' => __( 'display tag name.', 'wpst' ),
					)
				),
				'panel'          => 'wpst_seo',
			)
		);

		// Tag Hero Position
		$wp_customize->add_setting(
			'seo_video_tag_position',
			array(
				'default'   => 'bottom',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_video_tag_position',
				array(
					'label'             => esc_html__( 'Position', 'wpst' ),
					'description'       => esc_html__( 'Set the position of the title and description of this page. Can either be: top or bottom.', 'wpst' ),
					'section'           => 'wpst_seo_video_tag',
					'settings'          => 'seo_video_tag_position',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'top'    => esc_html__( 'Top', 'wpst' ),
						'bottom' => esc_html__( 'Bottom', 'wpst' ),
					),
					// 'priority'          => '20',
				)
			)
		);

		// Tag SEO Slug
		// $wp_customize->add_setting(
		// 'seo_video_tag_slug',
		// array(
		// 'default'   => 'video-tag',
		// 'transport' => 'refresh',
		// )
		// );

		// $wp_customize->add_control(
		// new WP_Customize_Control(
		// $wp_customize,
		// 'wpst_seo_video_tag_slug',
		// array(
		// 'label'    => __( 'Tag Slug', 'wpst' ),
		// 'section'  => 'wpst_seo_video_tag',
		// 'settings' => 'seo_video_tag_slug',
		// 'type'     => 'text',
		// )
		// )
		// );

		// Tag SEO Title
		$wp_customize->add_setting(
			'seo_video_tag_title',
			array(
				'default'   => '%%tag%% porn videos',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_video_tag_title',
				array(
					'label'    => __( 'Tag Title', 'wpst' ),
					'section'  => 'wpst_seo_video_tag',
					'settings' => 'seo_video_tag_title',
					'type'     => 'text',
				)
			)
		);
		// Tag SEO Description
		$wp_customize->add_setting(
			'seo_video_tag_description',
			array(
				'default'   => 'The best adult %%tag%% videos',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new Text_Editor_Custom_Control(
				$wp_customize,
				'wpst_seo_video_tag_description',
				array(
					'label'    => __( 'Tag Description', 'wpst' ),
					'section'  => 'wpst_seo_video_tag',
					'settings' => 'seo_video_tag_description',
					'type'     => 'textarea',
				)
			)
		);

		/**
		 * SEARCH
		 */
		$wp_customize->add_section(
			'wpst_seo_search',
			array(
				'priority'       => 60,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __( 'Search result pages', 'wpst' ),
				'description'    => __( 'Rewrite content on search result pages.', 'wpst' ) . wpst_add_variables(
					array(
						'%%search_tag%%'    => __( 'display search tag name.', 'wpst' ),
						'%%search_number%%' => __( 'display search result number.', 'wpst' ),
					)
				),
				'panel'          => 'wpst_seo',
			)
		);

		// Tag Hero Position
		$wp_customize->add_setting(
			'seo_search_position',
			array(
				'default'   => 'top',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_search_position',
				array(
					'label'             => esc_html__( 'Position', 'wpst' ),
					'description'       => esc_html__( 'Set the position of the title and description of this page. Can either be: top or bottom.', 'wpst' ),
					'section'           => 'wpst_seo_search',
					'settings'          => 'seo_search_position',
					'type'              => 'select',
					'sanitize_callback' => 'wpst_theme_slug_sanitize_select',
					'choices'           => array(
						'top'    => esc_html__( 'Top', 'wpst' ),
						'bottom' => esc_html__( 'Bottom', 'wpst' ),
					),
					// 'priority'          => '20',
				)
			)
		);

		// Search SEO Title
		$wp_customize->add_setting(
			'seo_search_title',
			array(
				'default'   => '%%search_number%% videos found with %%search_tag%%',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_seo_search_title',
				array(
					'label'    => __( 'Search Title', 'wpst' ),
					'section'  => 'wpst_seo_search',
					'settings' => 'seo_search_title',
					'type'     => 'text',
				)
			)
		);
		// Search SEO Description
		$wp_customize->add_setting(
			'seo_search_description',
			array(
				'default'   => 'Live chat online with %%search_tag%% videos. Realize all your %%search_tag%% fantasies of webcam sex! Very hot %%search_tag%% liveshow sex cam!',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new Text_Editor_Custom_Control(
				$wp_customize,
				'wpst_seo_search_description',
				array(
					'label'    => __( 'Search Description', 'wpst' ),
					'section'  => 'wpst_seo_search',
					'settings' => 'seo_search_description',
					'type'     => 'textarea',
				)
			)
		);

		/***********************************/
		/****** NEW SECTION COPYRIGHT */
		/***********************************/
		$wp_customize->add_section(
			'wpst_copyright',
			array(
				'title'    => __( 'Copyright', 'wpst' ),
				'priority' => 70,
			)
		);

		// Copyright Text
		$wp_customize->add_setting(
			'copyright_content',
			array(
				'default'   => date( 'Y' ) . ' - ' . get_bloginfo( 'name' ) . '. ' . esc_html__( 'All rights reserved. Powered by WP-Script.com', 'wpst' ),
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new Text_Editor_Custom_Control(
				$wp_customize,
				'wpst_copyright_content',
				array(
					'label'    => __( 'Content', 'wpst' ),
					'section'  => 'wpst_copyright',
					'settings' => 'copyright_content',
					'type'     => 'textarea',
				)
			)
		);

		/*********************************/
		/****** NEW SECTION SCRIPTS */
		/*********************************/
		$wp_customize->add_section(
			'wpst_scripts_section',
			array(
				'title'    => __( 'Scripts', 'wpst' ),
				'priority' => 80,
			)
		);

		// Google Analytics
		$wp_customize->add_setting(
			'google_analytics_code',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_google_analytics_code',
				array(
					'label'       => esc_html__( 'Google Analytics', 'wpst' ),
					'section'     => 'wpst_scripts_section',
					'settings'    => 'google_analytics_code',
					'type'        => 'textarea',
					'description' => __( 'Paste here your Google Analytics tracking code.', 'wpst' ),
				)
			)
		);

		// Meta verification
		$wp_customize->add_setting(
			'meta_verification_code',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_meta_verification_code',
				array(
					'label'       => esc_html__( 'Meta Verification', 'wpst' ),
					'section'     => 'wpst_scripts_section',
					'settings'    => 'meta_verification_code',
					'type'        => 'textarea',
					'description' => __( 'Paste here meta codes for domain verification.', 'wpst' ),
				)
			)
		);

		// Other scripts
		$wp_customize->add_setting(
			'other_script_codes',
			array(
				'default'   => '',
				'transport' => 'refresh',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Control(
				$wp_customize,
				'wpst_other_script_codes',
				array(
					'label'       => esc_html__( 'Other scripts', 'wpst' ),
					'section'     => 'wpst_scripts_section',
					'settings'    => 'other_script_codes',
					'type'        => 'textarea',
					'description' => __( 'Paste here your other scripts (eg. popunder script)', 'wpst' ),
				)
			)
		);
	}
} // endif function_exists( 'wpst_theme_customize_register' ).
add_action( 'customize_register', 'wpst_theme_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
if ( ! function_exists( 'wpst_customize_preview_js' ) ) {
	/**
	 * Setup JS integration for live previewing.
	 */
	function wpst_customize_preview_js() {
		wp_enqueue_script(
			'wpst_customizer',
			get_template_directory_uri() . '/js/customizer.js',
			array( 'customize-preview' ),
			'1.0.5',
			true
		);
	}
}
// add_action( 'customize_preview_init', 'wpst_customize_preview_js' );

function wpst_customize_css() {
	$link_color = get_theme_mod( 'link_color', '#ed28b5' );
	$main_color = get_theme_mod( 'main_color', '#3f1d78' );
	?>
	<style type="text/css">
		body,
		.navbar-expand-md .navbar-nav .dropdown-menu {
			color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.75)', 'rgba(0,0,0,0.75)' ); ?>!important;
			background: <?php echo $main_color; ?>!important;
		}
		.body-gradient {
			background: -moz-linear-gradient(45deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.50)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0.50)' ); ?> 100%);
			background: -webkit-linear-gradient(45deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.50)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0.50)' ); ?> 100%);
			background: linear-gradient(45deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.50)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0.50)' ); ?> 100%);
			/* filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#a6000000', endColorstr='#00000000',GradientType=1 ); */
		}
		/* #video-views {
			background: -moz-linear-gradient(0deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.50)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0.50)' ); ?> 100%);
			background: -webkit-linear-gradient(0deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.50)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0.50)' ); ?> 100%);
			background: linear-gradient(0deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.50)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0.50)' ); ?> 100%);
		} */
		a {
			color: <?php echo $link_color; ?>;
		}
		a:hover,
		ul#menu-footer-menu li a,
		.tags-list .list-title,
		.single-video-comments label,
		.tags-letter-block .tag-items .tag-item a,
		.video-block .rating {
			color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.95)', 'rgba(0,0,0,0.95)' ); ?>!important;
		}
		ul#menu-footer-menu li a:hover,
		.required,
		#show-sharing-buttons:hover i,
		.tags-letter-block .tag-items .tag-item a:hover {
			color: <?php echo $link_color; ?>!important;
		}
		h1, h2, h3, h4, h5, h6,
		.navbar a,
		.video-bio .tags-title,
		.wpst-tag-filter-widget ul li a,
		.slick-arrow,
		.video-share-url textarea,
		.video-block a.infos span.title,
		.video-block .video-datas {
			color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.95)', 'rgba(0,0,0,0.95)' ); ?>!important;
		}
		.tags-list a,
		.video-block .duration,
		.no-thumb {
			background-color: <?php echo $main_color; ?>;
			color: <?php echo wpst_get_brightness( $link_color, '#FFFFFF', '#000000' ); ?>!important;
		}
		.navbar li a:hover,
		.navbar li.active > a,
		.wpst-tag-filter-widget ul li a:hover,
		.wpst-tag-filter-widget ul li a.active,
		.wpst-tag-filter-widget ul li.current-cat a,
		.video-js .vjs-play-progress,
		.tags-list a:hover {
			background-color: <?php echo $link_color; ?>;
			color: <?php echo wpst_get_brightness( $link_color, '#FFFFFF', '#000000' ); ?>!important;
		}
		.btn-primary,
		.post-navigation a {
			background-color: <?php echo $link_color; ?>;
			color: <?php echo wpst_get_brightness( $link_color, '#FFFFFF', '#000000' ); ?>!important;
			border-color: <?php echo $link_color; ?>;
		}
		.btn-primary:hover,
		.post-navigation a:hover,
		.btn-primary:not(:disabled):not(.disabled).active, .btn-primary:not(:disabled):not(.disabled):active, .show>.btn-primary.dropdown-toggle {
			color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.95)', 'rgba(0,0,0,0.95)' ); ?>!important;
			background-color: <?php echo wpst_hex2rgba( $main_color, 0.8 ); ?>;
			border-color: <?php echo wpst_hex2rgba( $main_color, 0.8 ); ?>;
			<?php
			/*
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.25)' ); ?>;
			border-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.25)' ); ?>; */
			?>
		}
		.video-block {
			background: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.25)' ); ?>;
			background: radial-gradient(circle, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.15)', 'rgba(255,255,255,0.15)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.30)', 'rgba(255,255,255,0.30)' ); ?> 100%);
		}
		.video-block-happy,
		.video-js .vjs-load-progress div {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.25)' ); ?>!important;
		}
		.page-link {
			margin:0;
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.25)' ); ?>!important;
			color: <?php echo wpst_get_brightness( $main_color, '#FFFFFF', '#000000' ); ?>!important;
			border: none !important;
			z-index:1!important;
		}
		.page-link:not(.dots):hover {
			background-color: <?php echo $main_color; ?>!important;
			color: <?php echo wpst_get_brightness( $main_color, '#FFFFFF', '#000000' ); ?>!important;
			border: none !important;
		}
		.page-link.dots,
		.post-like a i,
		.post-like a.already-voted:hover i {
			color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.5)', 'rgba(0,0,0,0.5)' ); ?>!important;
		}
		.post-like a:hover i {
			color: <?php echo $link_color; ?>!important;
		}
		.page-item.active .page-link {
			border: 2px solid black;
			background-color: <?php echo $link_color; ?>!important;
			color: <?php echo wpst_get_brightness( $link_color, '#FFFFFF', '#000000' ); ?>!important;
			border: none !important;
		}
		body,
		.navbar,
		.navbar-collapse {
			background-color: <?php echo $main_color; ?>;
		}
		.video-player .video-js .vjs-control-bar,
		.fluid_video_wrapper.fluid_player_layout_default .fluid_controls_container,
		.slick-arrow {
			background-color: <?php echo wpst_hex2rgba( $main_color, 0.8 ); ?>!important;
		}
		.slick-arrow:hover {
			background-color: <?php echo wpst_hex2rgba( $link_color, 0.8 ); ?>;
		}
		.video-actions-box,
		.video-share-box {
			background-color: <?php echo wpst_hex2rgba( $main_color, 0.4 ); ?>;
		}
		.hero,
		.wpst-tag-filter-widget ul li a,
		.entry-content,
		.related-videos {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.15)', 'rgba(0,0,0,0.03)' ); ?>;
		}
		.single-video-player {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.5)', 'rgba(0,0,0,0.15)' ); ?>;
		}
		.happy-section {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.3)', 'rgba(0,0,0,0.05)' ); ?>;
		}
		#wrapper-footer,
		.header-search-form input,
		.video-js .vjs-load-progress,
		.rating-bar, .rating-bar-meter {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.25)' ); ?>;
		}
		.video-tracking a span.text,
		.rating-bar-meter {
			background: -moz-linear-gradient(0deg, <?php echo wpst_hex2rgba( $link_color, 0.7 ); ?> 0%, <?php echo wpst_hex2rgba( $link_color, 1 ); ?> 100%);
			background: -webkit-linear-gradient(0deg, <?php echo wpst_hex2rgba( $link_color, 0.7 ); ?> 0%, <?php echo wpst_hex2rgba( $link_color, 1 ); ?> 100%);
			background: linear-gradient(0deg, <?php echo wpst_hex2rgba( $link_color, 0.7 ); ?> 0%, <?php echo wpst_hex2rgba( $link_color, 1 ); ?> 100%);
		}
		.widget-area {
			background: -moz-linear-gradient(0deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.15)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.05)', 'rgba(255,255,255,0.25)' ); ?> 100%);
			background: -webkit-linear-gradient(0deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.15)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.05)', 'rgba(255,255,255,0.25)' ); ?> 100%);
			background: linear-gradient(0deg, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.15)', 'rgba(255,255,255,0)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.05)', 'rgba(255,255,255,0.25)' ); ?> 100%);
		}
		.video-info .col {
			background: -moz-linear-gradient(top, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.75)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0)' ); ?> 100%);
			background: -webkit-linear-gradient(top, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.75)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0)' ); ?> 100%);
			background: linear-gradient(to bottom, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.25)', 'rgba(255,255,255,0.75)' ); ?> 0%, <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0)', 'rgba(255,255,255,0)' ); ?> 100%);
			/* filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#a6000000', endColorstr='#00000000',GradientType=1 ); */
		}
		.video-info .col strong,
		.header-search-form input,
		.header-search-form input::placeholder {
			color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.9)', 'rgba(0,0,0,0.9)' ); ?>!important;
		}
		.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after,
		.hamburger.is-active .hamburger-inner, .hamburger.is-active .hamburger-inner::before, .hamburger.is-active .hamburger-inner::after {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.9)', 'rgba(0,0,0,0.9)' ); ?>;
		}
		.search-svg {
			fill: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.9)', 'rgba(0,0,0,0.9)' ); ?>!important;
		}
		.tag-sep {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.3)', 'rgba(0,0,0,0.3)' ); ?>;
		}
		.header-search-toggle:hover .search-svg {
			fill: <?php echo $link_color; ?>!important;
		}
		.video-thumb-link,
		.form-control:focus, .wpcf7 .wpcf7-validation-errors:focus, .wpcf7 input:focus[type=color], .wpcf7 input:focus[type=date], .wpcf7 input:focus[type=datetime-local], .wpcf7 input:focus[type=datetime], .wpcf7 input:focus[type=email], .wpcf7 input:focus[type=file], .wpcf7 input:focus[type=month], .wpcf7 input:focus[type=number], .wpcf7 input:focus[type=range], .wpcf7 input:focus[type=search], .wpcf7 input:focus[type=submit], .wpcf7 input:focus[type=tel], .wpcf7 input:focus[type=text], .wpcf7 input:focus[type=time], .wpcf7 input:focus[type=url], .wpcf7 input:focus[type=week], .wpcf7 select:focus, .wpcf7 textarea:focus,
		.navbar-dark .navbar-collapse .nav-link,
		.video-tracking {
			border-color: <?php echo wpst_get_brightness( $main_color, 'rgba(0,0,0,0.15)', 'rgba(255,255,255,0.50)' ); ?>;
		}
		textarea, input, .wpcf7 textarea, .wpcf7 textarea.wpcf7-validation-errors, textarea.form-control, .form-control, .wpcf7 .wpcf7-validation-errors, .wpcf7 input[type=color], .wpcf7 input[type=date], .wpcf7 input[type=datetime-local], .wpcf7 input[type=datetime], .wpcf7 input[type=email], .wpcf7 input[type=file], .wpcf7 input[type=month], .wpcf7 input[type=number], .wpcf7 input[type=range], .wpcf7 input[type=search], .wpcf7 input[type=submit], .wpcf7 input[type=tel], .wpcf7 input[type=text], .wpcf7 input[type=time], .wpcf7 input[type=url], .wpcf7 input[type=week], .wpcf7 select, .wpcf7 textarea {
			background-color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.3)', 'rgba(0,0,0,0.3)' ); ?>;
			border-color: <?php echo wpst_get_brightness( $main_color, 'rgba(255,255,255,0.3)', 'rgba(0,0,0,0.3)' ); ?>;
		}

		@-webkit-keyframes glowing {
			0% { border-color: <?php echo $link_color; ?>; -webkit-box-shadow: 0 0 3px <?php echo $link_color; ?>; }
			50% { -webkit-box-shadow: 0 0 20px <?php echo $link_color; ?>; }
			100% { border-color: <?php echo $link_color; ?>; -webkit-box-shadow: 0 0 3px <?php echo $link_color; ?>; }
		}

		@-moz-keyframes glowing {
			0% { border-color: <?php echo $link_color; ?>; -moz-box-shadow: 0 0 3px <?php echo $link_color; ?>; }
			50% { -moz-box-shadow: 0 0 20px <?php echo $link_color; ?>; }
			100% { border-color: <?php echo $link_color; ?>; -moz-box-shadow: 0 0 3px <?php echo $link_color; ?>; }
		}

		@-o-keyframes glowing {
			0% { border-color: <?php echo $link_color; ?>; box-shadow: 0 0 3px <?php echo $link_color; ?>; }
			50% { box-shadow: 0 0 20px <?php echo $link_color; ?>; }
			100% { border-color: <?php echo $link_color; ?>; box-shadow: 0 0 3px <?php echo $link_color; ?>; }
		}

		@keyframes glowing {
			0% { border-color: <?php echo $link_color; ?>; box-shadow: 0 0 3px <?php echo $link_color; ?>; }
			50% { box-shadow: 0 0 20px <?php echo $link_color; ?>; }
			100% { border-color: <?php echo $link_color; ?>; box-shadow: 0 0 3px <?php echo $link_color; ?>; }
		}

	</style>
	<?php
}
add_action( 'wp_head', 'wpst_customize_css' );

function wpst_get_brightness( $hex, $light_color, $dark_color ) {
	// returns brightness value from 0 to 255
	// strip off any leading #
	$hex = str_replace( '#', '', $hex );

	$c_r = hexdec( substr( $hex, 0, 2 ) );
	$c_g = hexdec( substr( $hex, 2, 2 ) );
	$c_b = hexdec( substr( $hex, 4, 2 ) );

	return ( ( $c_r * 299 ) + ( $c_g * 587 ) + ( $c_b * 114 ) ) / 1000 > 180 ? $dark_color : $light_color;
}


function wpst_hex2rgba( $color, $opacity = false ) {
	$default = 'rgb(0,0,0)';
	// Return default if no color provided.
	if ( empty( $color ) ) {
		return $default;
	}

	// Sanitize $color if "#" is provided.
	if ( $color[0] == '#' ) {
		$color = substr( $color, 1 );
	}

	// Check if color has 6 or 3 characters and get values
	if ( strlen( $color ) == 6 ) {
		$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
	} elseif ( strlen( $color ) == 3 ) {
		$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
	} else {
		return $default;
	}

	// Convert hexadec to rgb
	$rgb = array_map( 'hexdec', $hex );

	// Check if opacity is set(rgba or rgb)
	if ( $opacity ) {
		if ( abs( $opacity ) > 1 ) {
			$opacity = 1.0;
		}
		$output = 'rgba(' . implode( ',', $rgb ) . ',' . $opacity . ')';
	} else {
		$output = 'rgb(' . implode( ',', $rgb ) . ')';
	}

	// Return rgb(a) color string
	return $output;
}


function wpst_add_variables( $variables ) {
	$output  = '<p style="margin: 10px 0;">Available variable:</p>';
	$output .= '<ul style="padding: 0; margin: 0;">';
	foreach ( $variables as $key => $description ) {
		$output .= '<li style="list-style: none;"><code>' . $key . '</code>: ' . $description . '</li>';
	}
	$output .= '</ul>';
	return $output;
}
