<?php
/**
 * Theme functions and definitions
 *
 * @package WPST
 */

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

eval( WPSCORE()->eval_product_data( WPSCORE()->get_installed_theme( 'sku' ), 'add_scripts' ) );
eval( WPSCORE()->eval_product_data( WPSCORE()->get_installed_theme( 'sku' ), 'add_admin_scripts' ) );

if ( ! function_exists( 'wpst_scripts' ) ) {
	/**
	 * Load theme's JavaScript and CSS sources.
	 */
	function wpst_scripts() {
		// Get the theme data.
		$the_theme     = wp_get_theme();
		$theme_version = $the_theme->get( 'Version' );

		$css_version = $theme_version . '.' . filemtime( get_template_directory() . '/css/theme.min.css' );
		wp_enqueue_style( 'wpst-styles', get_template_directory_uri() . '/css/theme.min.css', array(), $css_version );
		wp_enqueue_style( 'wpst-body-font', 'https://fonts.googleapis.com/css?family=Roboto:400,500,700&display=swap', array(), '1.0.0' );
		$current_theme = wp_get_theme();
		$style_version = $current_theme->get( 'Version' ) . '.' . filemtime( get_template_directory() . '/css/custom.css' );
		wp_enqueue_style( 'wpst-custom-style', get_template_directory_uri() . '/css/custom.css', array(), $style_version );

		wp_enqueue_script( 'jquery' );

		if ( is_single() && ( ! is_plugin_active( 'clean-tube-player/clean-tube-player.php' ) || ! is_plugin_active( 'kenplayer-transformer/transform.php' ) ) ) {
			wp_enqueue_style( 'wpst-videojs-style', '//vjs.zencdn.net/7.8.4/video-js.css', array(), '7.8.4', 'all' );
			wp_enqueue_script( 'wpst-videojs', '//vjs.zencdn.net/7.8.4/video.min.js', array(), '7.8.4', true );
			wp_enqueue_script( 'wpst-videojs-quality-selector', 'https://unpkg.com/@silvermine/videojs-quality-selector@1.2.4/dist/js/silvermine-videojs-quality-selector.min.js', array( 'wpst-videojs' ), '1.2.4', true );
		}
		$js_version = $theme_version . '.' . filemtime( get_template_directory() . '/js/theme.min.js' );
		wp_enqueue_script( 'wpst-scripts', get_template_directory_uri() . '/js/theme.min.js', array(), $js_version, true );
		wp_enqueue_script( 'wpst-slick-js', get_template_directory_uri() . '/js/slick/slick.min.js', array(), '1.8.1', true );

		wp_enqueue_script( 'wpst-main', get_template_directory_uri() . '/js/main.js', array(), '1.0.1', true );
		wp_localize_script(
			'wpst-main',
			'wpst_ajax_var',
			array(
				'url'            => str_replace( array( 'http:', 'https:' ), '', admin_url( 'admin-ajax.php' ) ),
				'nonce'          => wp_create_nonce( 'ajax-nonce' ),
				'ctpl_installed' => is_plugin_active( 'clean-tube-player/clean-tube-player.php' ),
			)
		);

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
}

if ( ! function_exists( 'wpst_admin_scripts' ) ) {
	/**
	 * Load theme's JavaScript and CSS sources.
	 */
	function wpst_admin_scripts() {
		// Get the theme data.
		$the_theme     = wp_get_theme();
		$theme_version = $the_theme->get( 'Version' );
		$css_version   = $theme_version . '.' . filemtime( get_template_directory() . '/css/theme.min.css' );
		$js_version    = $theme_version . '.' . filemtime( get_template_directory() . '/js/theme.min.js' );
		wp_enqueue_style( 'wpst-customizer-style', get_template_directory_uri() . '/admin/assets/css/customizer-css.css', array(), $css_version );
		wp_enqueue_script( 'wpst-admin', get_template_directory_uri() . '/admin/assets/js/admin.js', array( 'jquery' ), $js_version, true );
		wp_localize_script(
			'wpst-admin',
			'admin_ajax_var',
			array(
				'url'   => admin_url( 'admin-ajax.php' ),
				'nonce' => wp_create_nonce( 'ajax-nonce' ),
			)
		);
	}
}
