<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;
get_header();

add_filter(
	'theme_mod_seo_related_videos_title',
	function ( $value ) {
		$video_title = get_the_title();
		$value       = str_replace( '%%video_title%%', $video_title, $value );
		return $value;
	}
); ?>

<div class="wrapper" id="single-wrapper">
	<?php
	if ( have_posts() ) :
		while ( have_posts() ) :
			the_post();
			get_template_part( 'loop-templates/content', 'single-video' );
		endwhile;
	endif;
	?>
	<?php
		$related_posts = get_posts(
			array(
				'category__in' => wp_get_post_categories( $post->ID ),
				'numberposts'  => '12',
				'post__not_in' => array( $post->ID ),
				'orderby'      => 'rand',
				'order'        => 'ASC',
			)
		);
		if ( $related_posts ) :
			?>
		<section class="related-videos">
			<div class="video-loop">
				<div class="container container-lg p-0">
					<h2 class="text-center"><?php echo esc_html( get_theme_mod( 'seo_related_videos_title', 'You like this video? You will also like...' ) ); ?></h2>
					<div class="row no-gutters">
						<?php
						foreach ( $related_posts as $post ) {
							get_template_part( 'loop-templates/loop', 'video' );
						}
						?>
					</div>
				</div>
			</div>
			<?php $category = get_the_category( $post->ID ); ?>
			<div class="text-center">
				<a class="btn btn-primary" href="<?php echo esc_url( get_category_link( $category[0]->term_id ) ); ?>"><?php esc_html_e( get_theme_mod( 'seo_more_related_videos_button', 'Show more related videos' ) ); ?></a>
			</div>
			<?php wpst_pagination(); ?>
		</section>

			<?php wp_reset_postdata(); ?>

			<?php if ( comments_open() || get_comments_number() ) : ?>
		<section class="single-video-comments">
			<div class="container">
				<div class="row">
					<div class="col-12 col-md-6 mx-auto">
						<?php comments_template(); ?>
					</div>
				</div>
			</div>
		</section>
		<?php endif; ?>
	<?php endif; ?>
</div>
<?php get_footer(); ?>
